# Sticky Notes

Sticky Notes are objects in a graph view that you can write in. They are the graph view equivalent of a comment in code, and consist of a title and body. You can create as many as you want in the graph, and use them for a variety of purposes, for example:

* To describe how a section of your graph works.
* To leave notes for yourself or others collaborating in your Unity Project.
* As a to-do list that includes tasks to complete at a later date.

## Using Sticky Notes

To create a Sticky Note, right-click an empty space in the graph view and, in the context menu, click **Create Sticky Note**. You can then customize and add content to the new Sticky Note. There are two text areas that you can write in:

* **Title**: The text area at the top of the Sticky Note is the title. You can use it to concisely describe what information the Sticky Note contains.
* **Body**: The larger text area below the title area is the body. You can write the full contents of the note here.

![](images/StickyNote.png)

### Editing text

To edit text on a Sticky Note, double-click on a text area. This also selects the entire text area, so be sure to move the cursor before you edit the text.

### Moving and resizing

You can move Sticky Notes anywhere on the graph. You can also click and drag to manually resize Sticky Notes, or have a Sticky Note automatically resize itself to fit the content. For information on how to make the Sticky Note resize itself, see **Fit To Text** in the [Context menu](#context-menu) section below.

### Duplicating

Use the following keyboard shortcuts to cut, copy, paste, and duplicate Sticky Notes.
* **Copy**: Ctrl+C
* **Cut**: Ctrl+X
* **Paste**: Ctrl+V
* **Duplicate**: Ctrl+D

<a name="context-menu"> </a>
### Context menu

To open the context menu for a Sticky Note, right-click anywhere on it. The options in the context menu are as follows.

| **Option**                 | **Description**                                              |
| -------------------------- | ------------------------------------------------------------ |
| **Dark Theme/Light Theme** | Toggles the color theme of the Sticky Note between light theme and dark theme. |
| **Text Size**              | Resizes the font in the text areas to the following point values. |
| Small                      | Title: 20, Body: 11                                          |
| Medium                     | Title: 40, Body: 24                                          |
| Large                      | Title: 60, Body: 36                                          |
| Huge                       | Title: 80, Body: 56                                          |
| **Fit To Text**            | Resizes the Sticky Note so that it precisely fits the text areas. If your title exceeds a single line, Unity resizes the Sticky Note such that title text fits on a single line. |
| **Delete**  | Deletes the Sticky Note you selected.|
| **Group Selection** |Places any Sticky Notes you select in a group.|
| **Ungroup Selection** |Removes any Sticky Notes you select from the group.|
